/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes;

import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.api.modelo.persistencia.AdministradorPersistencia;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.asistentes.AsistenteBase;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoMensajes;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.ImportarAnexoPaginaBusqueda;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.ImportarAnexoSeleccionPeriodo;
import ec.gob.sri.dimm.ats.ui.editores.InputEditorErroresInformacionATS;
import ec.gob.sri.dimm.ats.ui.operaciones.OperacionConvertirXSLT;
import ec.gob.sri.dimm.ats.ui.operaciones.OperacionValidacionAnexo;
import ec.gob.sri.dimm.ats.ui.operaciones.OperacionValidacionAnexoAntiguo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;

public class AsistenteConvertirATS
extends AsistenteBase
implements INewWizard {
    public static final String ID = "ec.gob.sri.dimm.ats.ui.asistentes.AsistenteConvertirATS";
    private ImportarAnexoSeleccionPeriodo paginaSeleccion;
    private ImportarAnexoPaginaBusqueda paginaBusqueda;
    private InputEditorErroresInformacionATS erroresAts;
    private static final boolean NO_ES_IMPORTACION = false;
    private boolean tieneErrores;
    private File archivoConvertido;

    public File getArchivoConvertido() {
        return this.archivoConvertido;
    }

    public void setArchivoConvertido(File archivoConvertido) {
        this.archivoConvertido = archivoConvertido;
    }

    public AsistenteConvertirATS() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.paginaSeleccion = new ImportarAnexoSeleccionPeriodo(false);
        this.paginaBusqueda = new ImportarAnexoPaginaBusqueda(false);
        this.addPage((IWizardPage)this.paginaSeleccion);
        this.addPage((IWizardPage)this.paginaBusqueda);
    }

    protected File getArchivoXML() {
        String rutaTemporalXML = AdministradorPersistencia.generarRutaArchivoXMLTemporal();
        File resultFile = new File(rutaTemporalXML);
        OperacionConvertirXSLT conversion = null;
        boolean validacionEsquemaExitosa = true;
        switch (this.paginaSeleccion.getTipo()) {
            case EXCEL: {
                ArrayList<String> xslFilters = new ArrayList<String>();
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/excelToAts.xsl");
                conversion = new OperacionConvertirXSLT(this.paginaBusqueda.getArchivoXML(), resultFile, xslFilters);
                try {
                    this.getContainer().run(true, false, (IRunnableWithProgress)conversion);
                    return resultFile;
                }
                catch (InvocationTargetException e1) {
                    PluginLogger.logError((String)"Error validando anexo externo.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    Throwable cause = e1.getCause();
                    this.verificarErrores(cause);
                    return null;
                }
                catch (InterruptedException e1) {
                    PluginLogger.logError((String)"Se ha interrumpido el proceso de conversi\u00f3n", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    this.mostrarError("Se ha interrumpido el proceso de conversi\u00f3n. Consulte el archivo de errores");
                    return null;
                }
            }
            case ARCHIVO_VIGENTE_HASTA_DIC_2007: {
                validacionEsquemaExitosa = this.validarEsquema(validacionEsquemaExitosa, "/ec/gob/sri/dimm/ats/validacion/esquema/xsd/at_2007.xsd");
                if (!validacionEsquemaExitosa) break;
                ArrayList<String> xslFilters = new ArrayList<String>();
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional2at.xslt");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional2013.xsl");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional2015.xsl");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional_2019_hasta_may_2020.xsl");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional_desde_jun_2020.xsl");
                conversion = new OperacionConvertirXSLT(this.paginaBusqueda.getArchivoXML(), resultFile, xslFilters);
                try {
                    this.getContainer().run(true, false, (IRunnableWithProgress)conversion);
                    return resultFile;
                }
                catch (InvocationTargetException e1) {
                    PluginLogger.logError((String)"Error validando anexo externo.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    Throwable cause = e1.getCause();
                    this.verificarErrores(cause);
                    return null;
                }
                catch (InterruptedException e1) {
                    PluginLogger.logError((String)"Se ha interrumpido el proceso de conversi\u00f3n", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    this.mostrarError("Se ha interrumpido el proceso de conversi\u00f3n. Consulte el archivo de errores");
                    return null;
                }
            }
            case ARCHIVO_VIGENTE_DESDE_ENE_2008_A_DIC_2012: {
                validacionEsquemaExitosa = this.validarEsquema(validacionEsquemaExitosa, "/ec/gob/sri/dimm/ats/validacion/esquema/xsd/at_2012.xsd");
                if (!validacionEsquemaExitosa) break;
                ArrayList<String> xslFilters = new ArrayList<String>();
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional2013.xsl");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional2015.xsl");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional_2019_hasta_may_2020.xsl");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional_desde_jun_2020.xsl");
                conversion = new OperacionConvertirXSLT(this.paginaBusqueda.getArchivoXML(), resultFile, xslFilters);
                try {
                    this.getContainer().run(true, false, (IRunnableWithProgress)conversion);
                    return resultFile;
                }
                catch (InvocationTargetException e1) {
                    PluginLogger.logError((String)"Error validando anexo externo.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    Throwable cause = e1.getCause();
                    this.verificarErrores(cause);
                    return null;
                }
                catch (InterruptedException e1) {
                    PluginLogger.logError((String)"Se ha interrumpido el proceso de conversi\u00f3n", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    this.mostrarError("Se ha interrumpido el proceso de conversi\u00f3n. Consulte el archivo de errores");
                    return null;
                }
            }
            case ARCHIVO_VIGENTE_DESDE_ENE_2013_A_FEB_2015: {
                validacionEsquemaExitosa = this.validarEsquema(validacionEsquemaExitosa, "/ec/gob/sri/dimm/ats/validacion/esquema/xsd/at_ene_2013_feb_2015.xsd");
                if (!validacionEsquemaExitosa) break;
                ArrayList<String> xslFilters = new ArrayList<String>();
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional2015.xsl");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional_2019_hasta_may_2020.xsl");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional_desde_jun_2020.xsl");
                conversion = new OperacionConvertirXSLT(this.paginaBusqueda.getArchivoXML(), resultFile, xslFilters);
                try {
                    this.getContainer().run(true, false, (IRunnableWithProgress)conversion);
                    return resultFile;
                }
                catch (InvocationTargetException e1) {
                    PluginLogger.logError((String)"Error validando anexo externo.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    Throwable cause = e1.getCause();
                    this.verificarErrores(cause);
                    return null;
                }
                catch (InterruptedException e1) {
                    PluginLogger.logError((String)"Se ha interrumpido el proceso de conversi\u00f3n", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    this.mostrarError("Se ha interrumpido el proceso de conversi\u00f3n. Consulte el archivo de errores");
                    return null;
                }
            }
            case ARCHIVO_VIGENTE_DESDE_MAR_2015_A_ABR_2016: {
                validacionEsquemaExitosa = this.validarEsquema(validacionEsquemaExitosa, "/ec/gob/sri/dimm/ats/validacion/esquema/xsd/at_mar_2015_abr_2016.xsd");
                if (!validacionEsquemaExitosa) break;
                ArrayList<String> xslFilters = new ArrayList<String>();
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional_2019_hasta_may_2020.xsl");
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional_desde_jun_2020.xsl");
                conversion = new OperacionConvertirXSLT(this.paginaBusqueda.getArchivoXML(), resultFile, xslFilters);
                try {
                    this.getContainer().run(true, false, (IRunnableWithProgress)conversion);
                    return resultFile;
                }
                catch (InvocationTargetException e1) {
                    PluginLogger.logError((String)"Error validando anexo externo.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    Throwable cause = e1.getCause();
                    this.verificarErrores(cause);
                    return null;
                }
                catch (InterruptedException e1) {
                    PluginLogger.logError((String)"Se ha interrumpido el proceso de conversi\u00f3n", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    this.mostrarError("Se ha interrumpido el proceso de conversi\u00f3n. Consulte el archivo de errores");
                    return null;
                }
            }
            case ARCHIVO_VIGENTE_DESDE_MAY_2016_A_MAY_2020: {
                validacionEsquemaExitosa = this.validarEsquema(validacionEsquemaExitosa, "/ec/gob/sri/dimm/ats/validacion/esquema/xsd/at_may_2016_may_2020.xsd");
                if (!validacionEsquemaExitosa) break;
                ArrayList<String> xslFilters = new ArrayList<String>();
                xslFilters.add("/ec/gob/sri/dimm/ats/validacion/esquema/xsl/transaccional_desde_jun_2020.xsl");
                conversion = new OperacionConvertirXSLT(this.paginaBusqueda.getArchivoXML(), resultFile, xslFilters);
                try {
                    this.getContainer().run(true, false, (IRunnableWithProgress)conversion);
                    return resultFile;
                }
                catch (InvocationTargetException e1) {
                    PluginLogger.logError((String)"Error validando anexo externo. 01", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    Throwable cause = e1.getCause();
                    this.verificarErrores(cause);
                    return null;
                }
                catch (InterruptedException e1) {
                    PluginLogger.logError((String)"Se ha interrumpido el proceso de conversi\u00f3n", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
                    this.mostrarError("Se ha interrumpido el proceso de conversi\u00f3n. Consulte el archivo de errores 01");
                    return null;
                }
            }
        }
        return null;
    }

    private boolean validarEsquema(boolean validacionEsquemaExitosa, String esquema) {
        OperacionValidacionAnexoAntiguo validacionAnexoAntiguo = new OperacionValidacionAnexoAntiguo(this.paginaBusqueda.getArchivoXML(), esquema);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)validacionAnexoAntiguo);
        }
        catch (InvocationTargetException e) {
            PluginLogger.logError((String)"Error validando anexo externo.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e);
            Throwable cause = e.getCause();
            this.verificarErrores(cause);
            return false;
        }
        catch (InterruptedException e) {
            PluginLogger.logError((String)"Se ha interrumpido el proceso de validaci\u00f3n", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e);
            this.mostrarError("Se ha interrumpido el proceso de conversi\u00f3n. Consulte el archivo de errores");
            return false;
        }
        ResultadoValidacion resultadoEsquema = validacionAnexoAntiguo.getResultadoValidacionEsquema();
        if (resultadoEsquema != null && (resultadoEsquema.tieneVariosErrores() || resultadoEsquema.tieneVariasAdvertencias())) {
            DialogoMensajes mensajesEsquema = new DialogoMensajes(this.getShell(), "Anexo Transaccional", resultadoEsquema.getMensajes());
            mensajesEsquema.open();
            validacionEsquemaExitosa = false;
        }
        return validacionEsquemaExitosa;
    }

    private void verificarErrores(Throwable cause) {
        if (cause == null) {
            this.mostrarError("Se ha producido un error inesperado al convertir el anexo.");
        } else if (cause instanceof OutOfMemoryError) {
            this.mostrarError("Estimado Contribuyente, para convertir archivos superiores a 15MB seguir la gu\u00eda del manual de usuario.");
        } else if (cause instanceof NullPointerException) {
            this.mostrarError("Estimado Contribuyente, el archivo no cumple con las especificaciones t\u00e9cnicas establecidas para el anexo ");
        } else if (cause instanceof IOException) {
            this.mostrarError("Estimado Contribuyente, no hay espacio en disco suficiente o no existen permisos para crear el archivo XML");
        } else {
            this.mostrarError("Estimado Contribuyente, el archivo no cumple con las especificaciones t\u00e9cnicas establecidas para el anexo ");
        }
    }

    public boolean performFinish() {
        this.archivoConvertido = this.getArchivoXML();
        if (this.archivoConvertido != null) {
            return this.validarAnexo(this.archivoConvertido);
        }
        return false;
    }

    protected boolean validarAnexo(File archivoAnexo) {
        File archivoErroresValidacion;
        OperacionValidacionAnexo operacionValidacion = new OperacionValidacionAnexo(archivoAnexo);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)operacionValidacion);
        }
        catch (InvocationTargetException e1) {
            PluginLogger.logError((String)"Error validando anexo externo.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
            Throwable cause = e1.getCause();
            this.verificarErrores(cause);
            return false;
        }
        catch (InterruptedException e1) {
            PluginLogger.logError((String)"Se ha interrumpido el proceso de validaci\u00f3n", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e1);
            this.mostrarError("Se ha interrumpido el proceso de conversi\u00f3n. Consulte el archivo de errores");
            return false;
        }
        boolean validacionExitosa = true;
        this.tieneErrores = false;
        ResultadoValidacion resultadoEsquema = operacionValidacion.getResultadoValidacionEsquema();
        if (resultadoEsquema != null && (resultadoEsquema.tieneVariosErrores() || resultadoEsquema.tieneVariasAdvertencias())) {
            DialogoMensajes mensajesEsquema = new DialogoMensajes(this.getShell(), "Anexo Transaccional", resultadoEsquema.getMensajes());
            mensajesEsquema.open();
            validacionExitosa = false;
            this.tieneErrores = true;
        }
        if (validacionExitosa && (archivoErroresValidacion = operacionValidacion.getArchivoErroresInformacion()) != null) {
            this.erroresAts = new InputEditorErroresInformacionATS(archivoErroresValidacion, archivoAnexo);
            if (operacionValidacion.isTieneErrores()) {
                validacionExitosa = false;
                this.tieneErrores = true;
            }
        }
        if (!validacionExitosa) {
            this.mostrarError(String.format("Se han producido errores al validar el anexo que est\u00e1 siendo importado.%n%nRevise los detalles de errores para obtener m\u00e1s informaci\u00f3n.", new Object[0]));
            return true;
        }
        return validacionExitosa;
    }

    public InputEditorErroresInformacionATS getErroresAts() {
        return this.erroresAts;
    }

    public void setErroresAts(InputEditorErroresInformacionATS erroresAts) {
        this.erroresAts = erroresAts;
    }

    public boolean isTieneErrores() {
        return this.tieneErrores;
    }

    public void setTieneErrores(boolean tieneErrores) {
        this.tieneErrores = tieneErrores;
    }
}

